library(mgcv)
library(plyr)
library(ggplot2)
library(reshape2)
library(foreach)
library(doParallel)

### CORRECTED !!!
# run with corrected files (folder: .../Corrected)

### RUN functions from files: 
# LPIMain.R
# ProcessFile.R
# CalcLPI.R
# calculate_index.R
# bootstrap_lpi.R
# debug_print.R
# plot_lpi.R
# ggplot_lpi.R
# ggplot_multi_lpi.R

# use_weightings = T -- taxa-specific lambdas are weighted by an estimated proportion of species richness of taxa
# use_weightings_B = T -- realm-specific lambdas are weighted by an estimated proportion of species richness of realms
# DATA_LENGTH_MIN = 2 -- time series with two and more data points are processed (in CalcLPI.R L106 is noted that time series with two data points are excluded, but the subsequent command does not correspond to this)
# PLOT_MAX -- PLOT_MAX - REF_YEAR + 2 = the number of values of Index (PLOT_MAX = 2015 -- LPI until 2016)
# CAP_LAMBDAS = F -- lambda values outside the limits (LAMBDA_MIN, LAMBDA_MAX) are not replaced by limit values (LAMBDA_MIN, LAMBDA_MAX)

# data: https://livingplanetindex.org/
# weights for taxa and realms: S10-S13 Table from McRae et al. 2017
# data for calculations converted into the format: columns (Binomial ID year popvalue), rows (populations), separately for each realm and taxon
# ..._infile.txt in the format: columns (FileName Group Weighting WeightingB)
# following objects saved in LPI_corrected.RData



# LPI of terrestrial amphibians
# compare with T_amph_org from LPI_original.RData (.../Original with marked errors)
# example of differences due to errors in the original code (differences are obvious if a smaller subset of the data is used)
T_amph_corr <- LPIMain(infile = "actual_data/Amphibia_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_amph_corr <- T_amph_corr[complete.cases(T_amph_corr),] 
ggplot_lpi(T_amph_corr, ylims=c(0, 2))

# LPI of terrestrial Neotropical mammals
# compare with T_mam_Neo_org from LPI_original.RData (.../Original with marked errors)
# example of differences due to errors in the original code (differences are obvious if a smaller subset of the data is used)
T_mam_Neo_corr <- LPIMain(infile = "actual_data/Mammals_Neotropical_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_mam_Neo_corr <- T_mam_Neo_corr[complete.cases(T_mam_Neo_corr),] 
ggplot_lpi(T_mam_Neo_corr, ylims=c(0, 2))

# LPI of the terrestrial ecosystem
# compare with T_org from LPI_original.RData (.../Original with marked errors)
# example of differences due to default settings (CAP_LAMBDAS=T in T_org) and errors in the original code
# if CAP_LAMBDAS=F, lambda values are not limited, LAMBDA_MIN and LAMBDA_MAX do not need to be set (corrected version of the code)
T_corr <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_corr <- T_corr[complete.cases(T_corr),] 
ggplot_lpi(T_corr, ylims=c(0, 2))




